function out = robuststd(data,dim) ;
% function out = robuststd(data,dim) ;
%
% Robust standard deviation of the columns of data.  The standard deviation is
%  robust in the sense that missing data (NaNs) are completely disregarded when
%  computing the standard deviation.
% dim denotes the dimension along which the mean is to be taken (default is 1).
% Note that robuststd divides by N rather than by N-1 when computing the
%  standard deviation.
%
% Written by Eric Swanson, 8/06.
%
% Edited by Andrew Tai, May 2016

if (nargin<2); dim=1; end ;
N = size(data) ;

stddata = (data - repmat(robustmean(data,dim), N(1) , 1 ) ).^2 ;

% Find and remove NaN's from the data:
good = ~isnan(data) ;
stddata(~good) = 0 ;

out = sqrt(sum(stddata,dim) ./sum(good,dim)) ;
